/******************************************************************************
 * %Id: icc_bridge_data.h,v 1.2 2008/12/10 04:36:56 taiyo Exp $
 *
 * FileName		:icc_bridge_data.h
 *
 * Description	:Definition header of data used in bridge
 *
 *
 * Copyright	:Panasonic Corporation.
 *
 *****************************************************************************/
#ifndef	_ICC_BRIDGE_DATA_H_
#define	_ICC_BRIDGE_DATA_H_

#define ICC_MAX_FD_NAME 256
#define ICC_BUF_SIZE    512

typedef struct {
    int cmd;
    int (*handler)(int,unsigned int,void *);
} icc_command_t;

struct icc_arg_t {
    int            error;
};

struct icc_status_arg_t {
    int            error;
    int            state;
};

struct icc_clocksrc_arg_t {
    int            error;
    long           icd_clk_ext;
    long           icd_clk_src;
};

struct icc_clockrate_arg_t {
    int            error;
    long           clock;
};

struct icc_setparams_arg_t {
    int            error;
    unsigned char  param;
    long           baudrate;
    long           guardtime;
    long           cwt;
    long           bwt;
    long           ifsc;
    unsigned char  ifsd;
};

struct icc_resetcard_arg_t {
    int            error;
    unsigned char  atrbuf[ICC_BUF_SIZE];
    long           atrlen;
    long           buflen;
};

struct icc_iosequence_arg_t {
    int            error;
    unsigned char  snddat[256];
    long           sndlen;
    unsigned char  rcvbuf[256];
    long           rcvlen;
    long           timeout;
};

#endif	/* _ICC_BRIDGE_DATA_H_ */

/* end of icc_bridge_data.h */
